<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormChangeProfile()
  ===================================================*/

  function ShowFormChangeProfile() {

    // vars global configuration
    global $theme_path;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $name, $email, $homepage, $icq, $yahoo, $aol, $biography, $interest, $location, $occupation;

    $users_obj = new clsUsers;
    $users_obj->table_name = "idx_users";
    $users_obj->template_file = $theme_path . "cp/profile_form.html";
    $users_obj->ChangeProfile("display_form", $_COOKIE['COOKIE_USERNAME']);
  }


  /*===================================================
    ProcessFormChangeProfile()
  ===================================================*/

  function ProcessFormChangeProfile() {

    // vars global configuration
    global $theme_path;

    // vars url & form
    global $name, $email, $homepage, $icq, $yahoo, $aol, $biography, $interest, $location, $occupation;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    $name       = stripslashes($name);
    $email      = stripslashes($email);
    $homepage   = stripslashes($homepage);
    $icq        = stripslashes($icq);
    $yahoo      = stripslashes($yahoo);
    $aol        = stripslashes($aol);
    $biography  = stripslashes($biography);
    $interest   = stripslashes($interest);
    $location   = stripslashes($location);
    $occupation = stripslashes($occupation);

    // verify input

    if (empty($name))
      $error_msg = $msg["20023"];
    elseif (empty($email))
      $error_msg = $msg["20021"];
    elseif (!IsEmailAddress($email))
      $error_msg = $msg["20022"];

    if (empty($error_msg)) {
      $users_obj = new clsUsers;
      $users_obj->table_name = "idx_users";
      $users_obj->template_file = $theme_path . "cp/profile_ok.html";
      $users_obj->ChangeProfile("process_form", $_COOKIE['COOKIE_USERNAME']);
    }
    else {
      ShowFormChangeProfile();
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormChangeProfile();
  }
  elseif ($pflag == 'change') {
    ProcessFormChangeProfile();
  }

  RunPostFilter(__FILE__);

?>